/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CComboBox.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CComboBox_h	// [
#define Included_CComboBox_h

#include "pgpClassesConfig.h"
#include "CWindow.h"

_PGP_BEGIN

// Class CComboBox

class CComboBox : public CWindow
{
public:
	CComboBox() { }
	CComboBox(HWND hWnd) : CWindow(hWnd) { }
	virtual ~CComboBox() { }

	PGPInt32	AddString(const char *s) const
	{
		return SendMessage(CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(s));
	}

	PGPInt32	DeleteString(PGPUInt32 i) const
	{
		return SendMessage(CB_DELETESTRING, i, 0);
	}

	PGPInt32	FindString(const char *string, PGPInt32 start = -1) const
	{
		return SendMessage(CB_FINDSTRING, start, 
			reinterpret_cast<LPARAM>(string));
	}

	PGPInt32	FindStringExact(const char *string, PGPInt32 start = -1) const
	{
		return SendMessage(CB_FINDSTRINGEXACT, start, 
			reinterpret_cast<LPARAM>(string));
	}

	PGPInt32	GetCount() const
	{
		return SendMessage(CB_GETCOUNT, 0, 0);
	}

	PGPInt32	GetCurSel() const
	{
		return SendMessage(CB_GETCURSEL, 0, 0);
	}

	PGPBoolean	GetExtendedUI() const
	{
		return (SendMessage(CB_GETEXTENDEDUI, 0, 0) ? TRUE : FALSE);
	}

	PGPUInt32	GetItemData(PGPInt32 index) const
	{
		return SendMessage(CB_GETITEMDATA, index, 0);
	}

	PGPInt32	GetLBText(PGPInt32 i, CString& text) const;

	PGPInt32	InsertString(PGPUInt32 i, const char *s) const
	{
		return SendMessage(CB_INSERTSTRING, i, reinterpret_cast<LPARAM>(s));
	}

	void		ResetContent() const
	{
		SendMessage(CB_RESETCONTENT, 0, 0);
	}

	PGPInt32	SetCurSel(PGPInt32 i) const
	{
		return SendMessage(CB_SETCURSEL, i, 0);
	}

	PGPInt32	SetExtendedUI(PGPBoolean onOrOff) const
	{
		return SendMessage(CB_SETEXTENDEDUI, onOrOff, 0);
	}

	void		SetItemData(PGPInt32 index, PGPUInt32 data) const
	{
		SendMessage(CB_SETITEMDATA, index, data);
	}
};

_PGP_END

#endif	// ] Included_CComboBox_h
